unit wmCommUnit;

{* Delphi Streaming Radio Library
 * Copyright 2004-2007, Steve Blinch
 * http://code.blitzaffe.com
 * ============================================================================
 *
 * LICENSE
 *
 * This code is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this code; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *}

// Unit description:
// Wrapper functions to automatically handle moving a variable to a block of
// memory, passing a pointer to that block of memory to PostMessage to post
// the pointer to the main window.  Also includes functions to take such a
// block of memory and return it to its original format.

interface

uses Messages,rawbufferUnit;

procedure wmSendString(WindowHandle: THandle; MessageID: Integer; S: String);
function wmReceiveString(var Msg: TMessage): String;

procedure wmSendBuffer(WindowHandle: THandle; MessageID: Integer; Buf: Pointer; Size: Integer); overload;
procedure wmSendBuffer(WindowHandle: THandle; MessageID: Integer; var Buf: TRawBuffer); overload;
procedure wmPostBuffer(WindowHandle: THandle; MessageID: Integer; Buf: Pointer; Size: Integer); overload;
procedure wmPostBuffer(WindowHandle: THandle; MessageID: Integer; var Buf: TRawBuffer); overload;
function wmReceiveBuffer(var Msg: TMessage): TRawBuffer;

implementation

uses Windows,dialogs,sysutils;





//                  we were using sendmessage instead of postmessage, so we've created a wmPostBuffer
//                  as well... now we need to go thru all our code and differentiate between the calls




procedure wmSendString(WindowHandle: THandle; MessageID: Integer; S: String);
var Buffer: TRawBuffer;
begin
  wmSendBuffer(WindowHandle,MessageID,@S[1],Length(S));
end;

function wmReceiveString(var Msg: TMessage): String;
var
  Buffer: TRawBuffer;
  S: String;
begin
  Buffer:=wmReceiveBuffer(Msg);

  SetLength(S,Buffer.Size);
  Buffer.Fetch(S[1],Buffer.Size);
  Buffer.Free;

  Result:=S;
end;

// Sends a COPY of the data in Buf to the main window.  DOES NOT DEALLOCATE Buf AFTER SENDING!
procedure wmSendBuffer(WindowHandle: THandle; MessageID: Integer; Buf: Pointer; Size: Integer);
var Buffer: TRawBuffer;
begin
  Buffer:=TRawBuffer.Create(Size);
  {$IFDEF RAWBUF_DEBUG}Buffer.SetID('wmSendBuffer');{$ENDIF}
  Buffer.Store(Buf^,Size);

  SendMessage(WindowHandle,WM_USER,MessageID,Integer(Buffer));
end;

// Sends a COPY of Buf to the main window.  DOES NOT DEALLOCATE Buf OR Buf's DATA AFTER SENDING!
procedure wmSendBuffer(WindowHandle: THandle; MessageID: Integer; var Buf: TRawBuffer);
begin
  SendMessage(WindowHandle,WM_USER,MessageID,Integer(Buf.Copy));
end;

// Posts a COPY of the data in Buf to the main window.  DOES NOT DEALLOCATE Buf AFTER SENDING!
procedure wmPostBuffer(WindowHandle: THandle; MessageID: Integer; Buf: Pointer; Size: Integer);
var Buffer: TRawBuffer;
begin
  Buffer:=TRawBuffer.Create(Size);
  {$IFDEF RAWBUF_DEBUG}Buffer.SetID('wmPostBuffer');{$ENDIF}
  Buffer.Store(Buf^,Size);

  PostMessage(WindowHandle,WM_USER,MessageID,Integer(Buffer));
end;

// Posts a COPY of Buf to the main window.  DOES NOT DEALLOCATE Buf OR Buf's DATA AFTER SENDING!
procedure wmPostBuffer(WindowHandle: THandle; MessageID: Integer; var Buf: TRawBuffer);
begin
  PostMessage(WindowHandle,WM_USER,MessageID,Integer(Buf.Copy));
end;

function wmReceiveBuffer(var Msg: TMessage): TRawBuffer;
begin
  Result:=TRawBuffer(Msg.LParam);
end;


end.
